	#!/bin/bash
	  # lancement de l'interpréteur wish\
	  exec wish "$0" "${1+"$@"}"
	  
	  
	  #______________________________________________________
	  #	vorteketo por IDOlinguo
	  # ______________________________________________________
	  

	  # licence NOL
	
	  #=======================================================


	# diciembro 2014 / februaro 2017
	# Ta programo es skribita precipue por la sistemo Android per la moyeno di AndroWish
	# tamen on povas uzar ol per windows, Mac or Linux or diversa altra sistemi operaciva 
	# qui havas interpretatoro por la languajo TCL/Tk.
	  #---------------------------------------------------------------------------------------------------
	
	
	
	 package require Tk
	
	#programme d'accueil pour les routines "Occurrences"
	# programo qua uzas la rutini "Occurences" por serchar elementi en texto.
	# ta rutini adaptita a la serchado de vorti di Ido permisas signalar vorti qui ne esas di ta linguo.
	# la vorti idala esas en la dokumento Dici.tcl, do sen ta dokumento apud vorteketo_xx.tcl, 
	# ta programo ne povas redigar la vorti eroroza.
	
	#kargar la dicionario
	
 	source [file join [file dirname [info script]]  Dici.tcl ] ; # dicionario generala >> dico(xx)

	
	#variabli totala
	
	global Voyo
	
	set Voyo(abs) [pwd]
	set Voyo(rel) [file dirname [info script]]
	
	
	global flag
	set flag 0
	
	variable programo
	set programo "VORTEKETO"
	
	variable versiono 1.1
	
	variable types {
		  { {dokumento Texto} {.ido}} {{datumi text} {.txt}} {{Omna datumi} {.*}}
		}
		
		global fichero
		set fichero ""
		
		global textofenestro
		set textofenestro .texto
	
	
	#<interfacio>
	
	wm title . "$programo $versiono > nova texto" 
	wm geometry .  [ expr {[winfo screenwidth . ]} *2/3]x[expr {[winfo screenheight . ]} *2/3]+30+50
	
	#menui
	menu .menubar  -background cyan -bd 4 -relief raised
		. config -menu .menubar 
				
		option add *Menu.activeBackground #d5ffff	 
   		option add *Menu.background aquamarine		
		option add *Menu.foreground blue  
		
  		foreach m { Menuo  Helpo} {
			set $m [ menu .menubar.m$m -tearoff 1]
			  .menubar add cascade -label $m -menu .menubar.m$m 	 
		}
		
		$Menuo add command -label "Apertar dokumento" 			-command { Kargartexto   .texto} -font {Helvetica 12}
			
		$Menuo add command -label "Salvigar texto" 			-command { Salvar} -font {Helvetica 12}
			
		$Menuo add command -label "Serchar" 			-command { Selektarvorto } -font {Helvetica 12}
		
		$Menuo add command -label "Verifikar" 			-command {VerifikarOrtografio   } -font {Helvetica 12}
		
		$Menuo add command -label "Livar" 			-command "exit" -background red -foreground yellow -font {Helvetica 12}
		
		$Helpo add command -label "Helpo" 			-command {Helpo  } -font {Helvetica 12}
		
		$Helpo add command -label "pri Vorteketo" 			-font {Helvetica 12} -command {tk_messageBox -message "Vorteketo da Lenadi Moucina \n versiono 1.1 februaro 2017 \n programo tote libera"}
		
		
		
	
	#butoni
	
	
	text .texto  -font {Times 12} -wrap word
	pack .texto -side bottom -expand 1 -fill both
	bind .texto <space> {OrtografioKlavaro }
	
	
	
proc Helpo {} {

set helpoTexto "Helpo pri Vorteketo

Vorteketo es formo simpla di Vorteko, editatoro de texto por la linguo IDO.

Vorteketo esis skribita por uzesar per la sistemo Android, per la moyeno di programo AndroWish.
Lu funcionas bone per altra sistemo quale Windows or Linux, ma Vorteko preferesos sur komputori klasika.

Vu devas havar la dokumento Dici.tcl apud vorteketo_xx.tcl en la sama dosiero.

Nur la texti en IDO povas esar korektigata segun du moyeni :

- kande on insertas spaco  pos vorto.
- kande on klikas sur la butono 'verifikar' (per muso o fingro)

La vorti qui ne esas en la dokumento Dici.tcl esas redigita.
Atenco! se vu skribas adjektivo vice  nomo o adverbo, Vorteketo ne vidas eroro. 
Exemplo : Statuo o statua esas vorti di IDO, do ne esas redigita ; do : 'la statua es bela' e  'la statuo es bela' paresas bona ambe por Vorteketo."
	
	tk_messageBox -message "$helpoTexto"
		}	
	
proc VerifikarOrtografio {  } { 
	OrtografioTotala
		}
	
		
proc Kargartexto { widtexto } {

	global flag
	global fichero
	global programo
	global versiono
		 
 set choix [ tk_getOpenFile -title "Vorteketo  : Apertar"]
		  if [ catch { open $choix } FIC ] {
		  tk_messageBox -type ok -icon warning \
			  -message "Ne es posible apertar dokumento $choix"
		  return 1
		} else {
		  $widtexto delete 0.0 end
		  set contenu [ read -nonewline $FIC ]
		  regsub -all {\ {4}} $contenu "\t" contenu
		  $widtexto insert 0.0 $contenu
		   		
		set flag 1
		  close $FIC
		
		set fichero $choix		
		wm title . "$programo $versiono  texto: $fichero "
		
		  return 0
		}
	  }
	
proc Salvar { } {

		global Voyo
		global fichero
		variable types
		variable programo
		global flag
		global versiono
		
		set selektajo 0
		  set selektajo [ tk_getSaveFile \
		-title "$programo : Salvar kom ..." -defaultextension .ido -filetypes $types] ;
		set fichero $selektajo

		if {[string compare $fichero	'0']== -1} {
		  tk_messageBox -type ok -icon warning \
			  -message "Erora skribo ... la dokumento ne ja memorigesis."
		} else {
			
			set dosiero [string match "$Voyo(rel)*" $selektajo	]
			
		 	if {$dosiero == 0} {
		
			set responso [tk_messageBox  -icon warning  -type yesno  -default no \
			-message  "Atencez! \nVu volas memorigar en la dosiero \n$Voyo(rel) \nTo es la dosiero dil nuna programo. \nKa vu volas vere facar to?." ]  
			switch $responso {
			no return
			}
		}
		
		  set idf [open $selektajo w]
		  set contenu [ .texto get 1.0 end ]
		  puts -nonewline $idf $contenu
		  close $idf
		  set fichero $selektajo
		tk_messageBox -message "la dokumento $fichero bone salvita "
		 }
		wm title . "$programo $versiono  texto: $fichero "
		}
	  
	
####################################################### 	  
#<ORTOGRAFIO>
#######################################################
 
# proc por kolorigar la vorti qui ne esas bona vorti di Idolinguo. 
# la erora vorti kolorigesor reda .

#ta proc OrtografioKlavaro funcionas kun la klaviero, kande la clavo espacio o la clavo "ritornar" basigesas. 

proc OrtografioKlavaro { } {

global dico
global textofenestro

$textofenestro tag configure  orto -foreground red  -underline true
# selektar la texto
set texto [$textofenestro get  "insert-1c linestart" "insert lineend" ]
# eliminar la nuna tagi
 $textofenestro tag remove orto "insert-1c linestart" "insert lineend" 
#eliminar virtuale la tireti, la hoketi, ed altra signi
regsub -all \\W $texto " " texto 

# lansar la slingo de verifiko de irga vorto 
set indico 1.0
foreach vorto $texto { 
	set indico [$textofenestro search $vorto $indico] 

# on regardas la du unesma literi di la vorto por serchar nur en un parto di la dicionario. 
				
	set alfa1 "[string tolower [ string index $vorto 0] ]"			
	set alfa2 "[ string tolower [string index $vorto 1] ]"	
	if { [ catch { set dicoAlfa $dico($alfa1$alfa2) 	} absento ]} {
		$textofenestro tag add orto $indico "$indico wordend" } else {
		if { [ lsearch $dico($alfa1$alfa2)  [string tolower $vorto ] ] == -1} { 	
		# serchar se on havas prefixi konocata ed rifacar sercho en la dicionarii pos eliminar la prefixo 
		regsub (ne|ad|ab|ca|en|ek|ri|ta|des|dis|min|mis|par|plu|pre|sam|sen|sub|sur|tra|tro|para|arki|inter|trans|kontre) [string tolower $vorto] "" vorto
		set alfa1 "[string tolower [ string index $vorto 0] ]"			
		set alfa2 "[ string tolower [string index $vorto 1] ]"	
		if { [ catch { set dicoAlfa $dico($alfa1$alfa2) 	} absento ]} {
		$textofenestro tag add orto $indico "$indico wordend" } else {
		if { [ lsearch $dico($alfa1$alfa2)  [string tolower $vorto ] ] == -1} { 			
		$textofenestro tag ad orto $indico "$indico wordend" 
		}
		}			
		}
	} 
	# augmentar la indico por ke irga okurenco di plura sama vorti eroroza esos kolorigata
	set indico "$indico+1c"
}

}

#<OrtografioTotala>

		proc OrtografioTotala { } {
global dico
global textofenestro

set debuto 1.0
set fino [.texto index end ]

 $textofenestro tag configure  orto -foreground red  -underline true

# eliminar la nuna tagi
$textofenestro tag remove orto $debuto $fino
# selektar la texto
set texto [$textofenestro get $debuto $fino ]

#eliminar virtuale la tireti, la hoketi, ed altra signi
regsub -all \\W $texto " " texto 

# lansar la slingo de verifiko de irga vorto 
set indico $debuto
foreach vorto $texto { 
	set indico [$textofenestro search $vorto $indico] 
	
# on regardas la du unesma literi di la vorto por serchar nur en un parto di la dicionario. 
				
	set alfa1 "[string tolower [ string index $vorto 0] ]"			
	set alfa2 "[ string tolower [string index $vorto 1] ]"	
	if { [ catch { set dicoAlfa $dico($alfa1$alfa2) 	} absento ]} {
		$textofenestro tag add orto $indico "$indico wordend" } else {
		if { [ lsearch $dico($alfa1$alfa2)  [string tolower $vorto ] ] == -1} { 	
		# serchar se on havas prefixi konocata ed rifacar sercho en la dicionarii pos eliminar la prefixo 
		regsub (ne|ad|ab|ca|en|ek|ri|ta|des|dis|min|mis|par|plu|pre|sam|sen|sub|sur|tra|tro|para|arki|inter|trans|kontre) [string tolower $vorto] "" vorto
		set alfa1 "[string tolower [ string index $vorto 0] ]"			
		set alfa2 "[ string tolower [string index $vorto 1] ]"	
		if { [ catch { set dicoAlfa $dico($alfa1$alfa2) 	} absento ]} {
		$textofenestro tag add orto $indico "$indico wordend" } else {
		if { [ lsearch $dico($alfa1$alfa2)  [string tolower $vorto ] ] == -1} { 			
		$textofenestro tag ad orto $indico "$indico wordend" 
		}
		}			
		}
	}
}
}

# efacar la koloro reda en la tota texto 

bind . <Escape> {DesRedigo}

proc DesRedigo {} {
	global textofenestro

	$textofenestro tag remove orto 1.0 end

}
	  
	  
	
	  ################################################################################
	  #	# enireyo por selektar la vorto por serchar lua aparuri (*okurensi )
	  ################################################################################
#<Okurensi>

proc Selektarvorto {} {

global textofenestro

		destroy .topvorto 	; # klozas la fenestro antee apertita 
		toplevel .topvorto		;  # apertas la fenestro di serchado 
		
		label .topvorto.label1 -text "serchar : " -width 25 -font "Helvetica 12"  -bg beige -justify left
		entry .topvorto.entrevorto  -textvariable vortoSerchata -font "Helvetica 12" -bg ivory -justify left
		checkbutton .topvorto.ch1 -text "Diferenciar Maj/Min" -variable majmin -onvalue 1 -offvalue 0 -font "Helvetica 12" -bg beige -justify left
		checkbutton .topvorto.ch3 -text "Anke en la celata texto	" -variable textoCelita  -onvalue 1 -offvalue 0 -font "Helvetica 12" -bg beige -justify left
		
		radiobutton .topvorto.ch4 -text "Dop kursoro	" -variable wards  -value forwards -font "Helvetica 12" -bg beige -justify left
		radiobutton .topvorto.ch5 -text "Avan kursoro	" -variable wards  -value backwards  -font "Helvetica 12" -bg beige -justify left
		radiobutton .topvorto.ch6 -text "Tote texto" -variable wards  -value 0  -font "Helvetica 12" -bg beige -justify left
		radiobutton .topvorto.ch7 -text "Texto selektata" -variable wards  -value selection  -font "Helvetica 12" -bg beige -justify left
		
		button .topvorto.ok -text "Serchar nun!" -bg beige -fg blue -font "Helvetica 12" -bd 5 -relief raise \
			 -command { set expressRegul 0 ;  AficharListoOkurensi .texto $vortoSerchata $wards $textoCelita $majmin $expressRegul} -justify left
		grid .topvorto.label1   -column 1 -row 1 -padx  3 -sticky ew
		grid .topvorto.entrevorto -column 1 -row 2 -padx 3 -sticky ew
		grid .topvorto.ch1 -column 1 -row 3 -padx 3 -sticky ew
		grid .topvorto.ch3 -column 1 -row 5 -padx 3  -sticky ew
		grid .topvorto.ch4 -column 1 -row 6 -padx 3  -sticky ew
		grid .topvorto.ch5 -column 1 -row 7 -padx 3  -sticky ew
		grid .topvorto.ch6 -column 1 -row 8 -padx 3  -sticky ew
		grid .topvorto.ch7 -column 1 -row 9 -padx 3  -sticky ew
		grid .topvorto.ok  -column 1 -row 10 -padx 3 -sticky ew
		
		bind .topvorto <3> {destroy .topvorto }
		
	  }
	  

proc  SercharElemento { textofenestro element wards textoCelita minMaj  expressRegul} { 
 
		variable ListoOkurensi
		set ListoOkurensi ""
		
		$textofenestro tag remove surligner 1.0 end
				
		 set indices [ $textofenestro tag ranges sel ]
		  if { [llength $indices] == 0  } {
		  set debut 1.0
		  set fin end
		} else {
		  	set indices [ $textofenestro tag ranges sel ]
		 	set debut [$textofenestro index  [lindex $indices 0]]
			set fin [$textofenestro index  [lindex $indices 1]]
			  }

		#diferenciar la  mayuskuli de et des minuskili
		if {$minMaj == 1} {
		set  casse ""
		} else {
		 set casse "-nocase"
		}
		
		# ta lineo remplacas la buklo "if" di la unesma programo nur por programeri qui konocas la " regula expresi" en Tcl
		set ListeOccurences ""
		if {$expressRegul==1} {
		  set com "-regexp $casse \{$element\}"
		} else {		  
		  set com \"$element\"
		}
		
		# serchar en o ek la texto celata 
		
		if {$textoCelita == 1} {
			set masque "-elide"
		} else {
			set masque ""
		}
		
		#direciono di la sercho 
				
		switch $wards forwards {set debut [$textofenestro index insert] ; set fin end  }
		switch $wards backwards {set fin [$textofenestro index insert] ;set debut 1.0 }
		switch $wards 0 {set fin end  }
		switch $wards "" {set debut 1.0 ; set fin end  }
		switch $wards "selection" {set debut $debut ; set fin $fin  }
		
		# slingo di sercho qua skribas la indici di irga *okurenci en listo : "ListoOkurensi"
		
		if {[string length $com ]==2} {	tk_messageBox -message "vu mustas serchar kelka kozo!" } else {
			while 1 {
		  		set lacom "$textofenestro search $casse $masque -count longeso $com  \"$debut\" \"$fin\" "
		 		 set indice [eval $lacom]
		 		 if {$indice==""} { break }
				  lappend ListoOkurensi $indice
				  set debut "$indice + $longeso char"
		}}
		
	
	}
	
	
proc  AficharListoOkurensi { textofenestro element wards textoCelita majmin expressRegul} {
		variable ListoOkurensi
		
		
		destroy .topvorto.fenoccs
		destroy .topvorto.occssy
		scrollbar .topvorto.occssy -orient vertical -command ".topvorto.fenoccs yview" -cursor "hand2"
		text  .topvorto.fenoccs -wrap word -bd 6 -relief raised -bg lavender -fg black \
			-tabs {1c} -font "Helvetica 12"	-height 10 -yscrollcommand ".topvorto.occssy set" -width 40 -cursor "hand1" -state normal
		
		
		
	  SercharElemento $textofenestro $element $wards $textoCelita $majmin $expressRegul
		
		grid .topvorto.fenoccs  -row 11 -column 1 -rowspan 5
		grid .topvorto.occssy -row 11 -column 2 -rowspan 5 -sticky ns
		
		# lanceo de la slingo di afishigo en la fenestro kreita en la lineo supere 
		set compteur 0
		if {[llength $ListoOkurensi]!=0} {
		  foreach el $ListoOkurensi {
			
			set ligneOkurenso "... lineo N° $el esma tipo..." ; # $el es un indico text (ex : 10.5 ) N°lineo.N°signo
			
			$textofenestro tag add surligner $el
			$textofenestro tag configure surligner -background yellow
			
			.topvorto.fenoccs insert end "Okurenco $compteur : $ligneOkurenso"
			.topvorto.fenoccs tag add $compteur "current linestart" "current lineend"
			.topvorto.fenoccs tag configure $compteur -foreground blue -underline 1
			.topvorto.fenoccs tag bind $compteur <1> "$textofenestro see $el ;destroy .topBuloOkurenso "
			
			.topvorto.fenoccs tag bind $compteur <Enter> ".topvorto.fenoccs tag configure $compteur -background AntiqueWhite  -foreground blue -underline 1 ;  BuloOkurenso $textofenestro $el"
			.topvorto.fenoccs tag bind $compteur <Leave> " .topvorto.fenoccs tag configure $compteur -background  lavender  ; destroy .topBuloOkurenso "
			
			.topvorto.fenoccs insert end \n
			incr compteur
			
			
		  }
		}
		.topvorto.fenoccs insert 1.0 "$compteur okurensi de \"$element\"\n\n"
		
		# komando precipue por uzar Vorteketo per Androwish sur Android, por evitar la afishago  di klaviero virtuela 
		# envadanto kande on klikas per muso-butono o pozas fingro sur lineo di okurencajo en la panelo di resultaji di la serchado.
		.topvorto.fenoccs configure -state disabled
		
		bind .topvorto.fenoccs <3> {	destroy .topBuloOkurenso  ;	destroy .topvorto	; $textofenestro tag remove "surligner" 1.0 end ; }
	  }
	  
proc  BuloOkurenso { textofenestro indice} {
		toplevel .topBuloOkurenso
		text .topBuloOkurenso.texto  -height 1 -bg White -fg tomato -relief raised -borderwidth 2
		
		wm overrideredirect .topBuloOkurenso 0 ; # 1 = deskreas la stango de titulo 
		set x [ winfo pointerx . ]
		set y [ winfo pointery . ]
		wm geometry .topBuloOkurenso  +[expr $x + 10]+[expr $y - 10]
		
		set contenuLigneOkurenso [ string trimleft [$textofenestro get "$indice linestart" "$indice  lineend" ] " \t"]
		set contenuLigneOkurenso [ string trimright $contenuLigneOkurenso " " ]
		.topBuloOkurenso.texto insert end $contenuLigneOkurenso
		
				
		pack .topBuloOkurenso.texto
		.topBuloOkurenso.texto configure -width [string length $contenuLigneOkurenso ] 		
		
		 bind .topBuloOkurenso.texto <1> {catch [sdltk textinput off] }
		
	  }
	  
	  ###############################
	  #<remplaso>
	  
proc  Remplasar {textofenestro } {
		destroy .topRemplace 	; # klozas la fenestro ja apertita
		toplevel .topRemplace		; # aperta la fenestro di sercho 
		
		label .topRemplace.label1 -text "remplasar : "
		entry .topRemplace.entrevorto  -textvariable vortoSerchata
		label .topRemplace.label2 -text "per : "
		entry .topRemplace.entreRemplaso  -textvariable aLaPlace
		button .topRemplace.ok -text "lansar la inquesto remplasante"  -command {  :RemplasarNun $textofenestro $vortoSerchata $aLaPlace $majmin }
		checkbutton .topRemplace.ch1 -text "Diferenciar Maj/Min" -variable majmin -onvalue 1 -offvalue 0
		button .topRemplace.b2 -text "Remplasar tote" -command {  :RemplasarTote $textofenestro $vortoSerchata $aLaPlace $majmin }
		
		grid .topRemplace.label1   -column 1 -row 1 -padx  8
		grid .topRemplace.entrevorto -column 1 -row 2 -padx 8
		grid .topRemplace.label2   -column 1 -row 3 -padx  8
		grid .topRemplace.entreRemplaso -column 1 -row 4 -padx 8
		grid .topRemplace.ok  -column 1 -row 5 -padx 8
		grid .topRemplace.ch1 -column 2 -row 1 -padx 8
		grid .topRemplace.b2 -column 2 -row 5 -padx 8
		
		bind .topRemplace <3> {destroy .topRemplace}
	  }
	  
proc  RemplasarNun { textofenestro vortoif remplaso mM } {
		$textofenestro tag configure serchoTago -background red -foreground yellow 
		
		if {$mM == 0} {
		  regexp  -indices -nocase -- $vortoif [$textofenestro get 1.0 end ]  indiciRemplaso
		} else {
		  regexp  -indices -- $vortoif [$textofenestro get 1.0 end ]  indiciRemplaso
		}
		

		if { [catch {
			$textofenestro delete "1.0 + [expr [lindex  $indiciRemplaso 0] ] chars" \
			"1.0 + [expr [lindex $indiciRemplaso  1 ] +1] chars "
			$textofenestro insert  "1.0 +  [lindex  $indiciRemplaso 0] chars"  $remplaso
		$textofenestro tag add serchoTago "1.0 + [lindex  $indiciRemplaso 0] chars"  "1.0 + [expr  [lindex  $indiciRemplaso 0] + [string length $remplaso] ] chars"
			} ]  !=0
			}  { tk_messageBox -message "Ne altra okurenci a remplasar per  \"$remplaso\" " 
			$textofenestro tag delete serchoTago
			}
		
	  }
	  
proc  RemplasarTote { textofenestro vortoif remplaso mM} {
		set i 0
		set tmM [ regexp  -indices -nocase -all -- $vortoif [$textofenestro get 1.0 end ] ]
		set t [ regexp  -indices -all -- $vortoif [$textofenestro get 1.0 end ] ]
		
		if {$mM == 0} {
		  while {$i <  $tmM } {
			regexp  -indices -nocase -- $vortoif [$textofenestro get 1.0 end ]  indiciRemplaso
			$textofenestro delete "1.0 + [expr [lindex  $indiciRemplaso 0] ] chars" \
				"1.0 + [expr [lindex $indiciRemplaso  1 ] +1] chars "
			$textofenestro insert  "1.0 +  [lindex  $indiciRemplaso 0] chars"  $remplaso
			
			incr i
		  }
		} else {
		  while {$i < $t} {
			regexp  -indices  -- $vortoif [$textofenestro get 1.0 end ]  indiciRemplaso
			$textofenestro delete "1.0 + [expr [lindex  $indiciRemplaso 0] ] chars" "1.0 + [expr [lindex $indiciRemplaso  1 ] +1] chars "
			$textofenestro insert  "1.0 +  [lindex  $indiciRemplaso 0] chars"  $remplaso
			
			incr i
		  }
		}
		
		tk_messageBox -message " Serchado e remplasado nun finita. \nNombro de chanji : $i "
	  }
	
	###############################################################
	
	


